/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/  
/**
 * \file    DM814x_pll.h
 *
 * \brief   Defines the module register defines for PLL
 *
 * This header file contains the Macros definitions and the
 * register overlay structure for DM814x PLL controller.
 *
 * \author  0043
 *
 * \version 01a,09aug,2010 Created.
 */

#ifndef _DM814x_pll_H_
#define _DM814x_pll_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_SoC.h"

/**
@addtogroup DM814x PLL
@{
*/

/*
 *====================
 * Enumerations
 *====================
 */
/**
 * \brief PLL Clocking Mode
 *
 *  This enumeration defines the various cloking mode of the PLL
 */
typedef enum eDm814x_Pll_clk_mode
	{
	PLL_CLKIN = 0,	/**< Clock in from Oscillator  	*/
	PLL_OCSIN = 1	/**< Clock in from Oscillator 	*/
	} eDm814x_Pll_clk_mode;

/**
@addtogroup DM814x PLL-0 Controller
@{
*/
#define PLL0_BASE               0x01c40800
#define PLL0_PID                *( volatile Uint32* )( PLL0_BASE + 0x0 )
#define PLL0_RSTYPE             *( volatile Uint32* )( PLL0_BASE + 0xe4 )
#define PLL0_PLLCTL             *( volatile Uint32* )( PLL0_BASE + 0x100 )
#define PLL0_PLLM               *( volatile Uint32* )( PLL0_BASE + 0x110 )
#define PLL0_PLLDIV1            *( volatile Uint32* )( PLL0_BASE + 0x118 )
#define PLL0_PLLDIV2            *( volatile Uint32* )( PLL0_BASE + 0x11c )
#define PLL0_PLLDIV3            *( volatile Uint32* )( PLL0_BASE + 0x120 )
#define PLL0_POSTDIV            *( volatile Uint32* )( PLL0_BASE + 0x128 )
#define PLL0_BPDIV              *( volatile Uint32* )( PLL0_BASE + 0x12c )
#define PLL0_PLLCMD             *( volatile Uint32* )( PLL0_BASE + 0x138 )
#define PLL0_PLLSTAT            *( volatile Uint32* )( PLL0_BASE + 0x13c )
#define PLL0_ALNCTL             *( volatile Uint32* )( PLL0_BASE + 0x140 )
#define PLL0_DCHANGE            *( volatile Uint32* )( PLL0_BASE + 0x144 )
#define PLL0_CKEN               *( volatile Uint32* )( PLL0_BASE + 0x148 )
#define PLL0_CKSTAT             *( volatile Uint32* )( PLL0_BASE + 0x14c )
#define PLL0_SYSTAT             *( volatile Uint32* )( PLL0_BASE + 0x150 )
#define PLL0_PLLDIV4            *( volatile Uint32* )( PLL0_BASE + 0x160 )
#define PLL0_PLLDIV5            *( volatile Uint32* )( PLL0_BASE + 0x164 )
#define PLL0_PLLDIV6            *( volatile Uint32* )( PLL0_BASE + 0x168 )
#define PLL0_PLLDIV7            *( volatile Uint32* )( PLL0_BASE + 0x16c )
#define PLL0_PLLDIV8            *( volatile Uint32* )( PLL0_BASE + 0x170 )
#define PLL0_PLLDIV9            *( volatile Uint32* )( PLL0_BASE + 0x174 )
/* @} */   /* End of PLL-0 Controller */
/**
@addtogroup DM814x PLL-1 Controller
@{
*/
#define PLL1_BASE               0x01c40c00
#define PLL1_PID                *( volatile Uint32* )( PLL1_BASE + 0x0 )
#define PLL1_PLLCTL             *( volatile Uint32* )( PLL1_BASE + 0x100 )
#define PLL1_PLLM               *( volatile Uint32* )( PLL1_BASE + 0x110 )
#define PLL1_PLLDIV1            *( volatile Uint32* )( PLL1_BASE + 0x118 )
#define PLL1_POSTDIV            *( volatile Uint32* )( PLL1_BASE + 0x128 )
#define PLL1_PLLCMD             *( volatile Uint32* )( PLL1_BASE + 0x138 )
#define PLL1_PLLSTAT            *( volatile Uint32* )( PLL1_BASE + 0x13c )
#define PLL1_ALNCTL             *( volatile Uint32* )( PLL1_BASE + 0x140 )
#define PLL1_DCHANGE            *( volatile Uint32* )( PLL1_BASE + 0x144 )
#define PLL1_CKEN               *( volatile Uint32* )( PLL1_BASE + 0x148 )
#define PLL1_CKSTAT             *( volatile Uint32* )( PLL1_BASE + 0x14c )
#define PLL1_SYSTAT             *( volatile Uint32* )( PLL1_BASE + 0x150 )
/* @} */   /* End of PLL-1 Controller */
	
/*
 *====================
 * Defines
 *====================
 */

/* @} */   /* End of PLL */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM814x_pll_H_ */
